IF ((SELECT IS_NULLABLE 
FROM INFORMATION_SCHEMA.COLUMNS 
WHERE TABLE_SCHEMA='DBO' 
      AND TABLE_NAME='RC_RESP_TEC' 
      AND COLUMN_NAME='CNPJ_RESPTEC') = 'YES')
BEGIN
	ALTER TABLE [dbo].[RC_RESP_TEC] ALTER COLUMN [CNPJ_RESPTEC] VARCHAR(14) NOT NULL;
END;
GO

IF ((SELECT COUNT(COLUMN_NAME)
FROM INFORMATION_SCHEMA.KEY_COLUMN_USAGE
WHERE OBJECTPROPERTY(OBJECT_ID(CONSTRAINT_SCHEMA + '.' + QUOTENAME(CONSTRAINT_NAME)), 'IsPrimaryKey') = 1
AND TABLE_NAME = 'RC_RESP_TEC') = 1)
BEGIN
	ALTER TABLE [dbo].[RC_RESP_TEC] DROP CONSTRAINT [PK_RC_RESP_TEC] WITH ( ONLINE = OFF );
	ALTER TABLE [dbo].[RC_RESP_TEC] ADD  CONSTRAINT [PK_RC_RESP_TEC] PRIMARY KEY CLUSTERED 
	(
		[CD_EMP] ASC,
		[CNPJ_RESPTEC] ASC
	)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY];
END;
GO

IF NOT EXISTS(SELECT TOP 1 1 
		  FROM RC_RESP_TEC 
		  WHERE CD_EMP = 1 
				AND CNPJ_RESPTEC = '54517628000198')
BEGIN
	INSERT INTO RC_RESP_TEC 
	VALUES (1,'54517628000198','Leonardo Areas','lideranca.ped@linx.com.br','1130030400');
END;
